// Dependencies: MqSysutils.js
function CMqSysMsg(objMessage, strReceivers, blnIncludeReceivers)
{
	
	// The responses that are system messages (from system), should all begin with
	var SYS_MSG_PREFIX  = "SYS_MSG_";
	var SYS_MSG_TIMEOUT = SYS_MSG_PREFIX + "TIMEOUT";
	var SYS_MSG_ADMIN_REQUEST = SYS_MSG_PREFIX + "ADMIN_REQUEST";
	var SYS_MSG_TEMPLATE_CHANGE = SYS_MSG_PREFIX + "TEMPLATE_CHANGE";
	var SYS_MSG_UNDEFINED = SYS_MSG_PREFIX + "UNDEFINED";
	var SYS_MSG_PSW_CHANGE=SYS_MSG_PREFIX + "PSW_CHANGE";

	var LENGTH_SYS_MSG_PREFIX=SYS_MSG_PREFIX.length;
	
	// Messages
	var SYS_MSG_TIMEOUT_MESSAGE=g_MqRef.RESX["SYS_MSG_TIMEOUT_MESSAGE"];
	var SYS_MSG_TIMEOUT_MESSAGE_ASK=g_MqRef.RESX["SYS_MSG_TIMEOUT_MESSAGE_ASK"];
	var SYS_MSG_ADMIN_REQUEST_MESSAGE = g_MqRef.RESX["SYS_MSG_ADMIN_REQUEST_MESSAGE"];
	var SYS_MSG_TEMPLATE_CHANGE_MESSAGE =g_MqRef.RESX["SYS_MSG_TEMPLATE_CHANGE_MESSAGE"];
	var SYS_MSG_PSW_CHANGE_MESSAGE=g_MqRef.RESX["SYS_MSG_PSW_CHANGE_MESSAGE"];
	var SYS_MSG_UNDEFINED_MESSAGE = SYS_MSG_ADMIN_REQUEST_MESSAGE;
	var MSG_ASK_EXIT =g_MqRef.RESX["MSG_ASK_EXIT"];
	//Constructor
	var mobjMessage=objMessage;
	var mstrReceivers=strReceivers;
	var m_blnIncludeReceivers=blnIncludeReceivers;
	// End Constructor
	//private properties
	var mblnDoingSysMsg;
	
	function GetMessage()
	{
	 return mobjMessage; 
	}
	function SetMessage(objMessage)
	{
		mobjMessage=objMessage 
	}
	function GetReceivers()
	{
		return mstrReceivers;
	}
	
	function SetReceivers(strReceivers)
	{
		mstrReceivers=strReceivers;
	}
	
	function SetInclude(blnInclude)
	{
		m_blnIncludeReceivers=blnInclude;
	}
	
	function GetInclude()
	{
		return m_blnIncludeReceivers;
	}
		
	function isSysMsg(strMessage){
		
		strMessage=String(strMessage);
		
		if (strMessage.substr(0,LENGTH_SYS_MSG_PREFIX)==SYS_MSG_PREFIX){
			return true;
		}else{
			return false;
		}
	}
	
	function doSysMsg(strMessage,strSysMsg,bForceExit){
	
			if (mblnDoingSysMsg){
				return true;
			}
		
			mblnDoingSysMsg=true;
			
			//notify the parent
			if (window.parent){
		
				if (window.parent!=window.self){
					if (window.parent.objSysMsg){
						window.parent.objSysMsg.doSysMsg(strMessage,strSysMsg,bForceExit);
						return true;
					}
				}
			
			}
			
			
			//notify the opener		
			if (window.opener) {
	
				if (window.opener!=window.self){
					if (window.opener.objSysMsg){
						window.opener.objSysMsg.doSysMsg(strMessage,strSysMsg,bForceExit);
						window.close();
						return true;
					}
				}
			}

			if ((!strSysMsg)||(strSysMsg.length=0)){
				strSysMsg=GetSysMsgText(strMessage);
			}

			bForceExit=parseInt(bForceExit);
			
			if (strSysMsg){
				if (!bForceExit){
					strSysMsg=unescape(strSysMsg)+MSG_ASK_EXIT;
					ConfirmExit(strSysMsg);
				}else{
					g_MqRef.MsgHlpr.DisplayMessage(unescape(strSysMsg));	
					window.exit(true);
				}
				mblnDoingSysMsg=false;
			}
		
	}
	
	this.isSysMsg=isSysMsg;
	this.doSysMsg=doSysMsg;
	this.GetMessage=GetMessage;
	this.SetMessage=SetMessage;
	this.GetReceivers=GetReceivers;
	this.SetReceivers=SetReceivers;
	this.GetInclude=GetInclude;
	this.SetInclude=SetInclude;
	
	
	// Private functions
	
	function ConfirmExit(strMsg){
			if (window.confirm(unescape(strMsg))){							
				//if the function exists then call it
				if (window.exit) {
					window.exit(true);											
				}							
		   }
	}
	

	function GetSysMsgText(strSysMsgType){
		
		//var strMessageTypeID;
		
		strSysMsgType=String(strSysMsgType);

		if (strSysMsgType.substr(0,SYS_MSG_TIMEOUT.length)==SYS_MSG_TIMEOUT)
		{		
				
					return SYS_MSG_TIMEOUT_MESSAGE_ASK;
				
					//return SYS_MSG_TIMEOUT_MESSAGE;

		}

		
		if (strSysMsgType.substr(0,SYS_MSG_ADMIN_REQUEST.length)==SYS_MSG_ADMIN_REQUEST){
			return SYS_MSG_ADMIN_REQUEST_MESSAGE;
		}
				
		if (strSysMsgType.substr(0,SYS_MSG_TEMPLATE_CHANGE.length)==SYS_MSG_TEMPLATE_CHANGE){
			return SYS_MSG_TEMPLATE_CHANGE_MESSAGE;
		}
				
		if (strSysMsgType.substr(0,SYS_MSG_UNDEFINED.length)==SYS_MSG_UNDEFINED){
			return SYS_MSG_UNDEFINED_MESSAGE;
		}
		
		if (strSysMsgType.substr(0,SYS_MSG_PSW_CHANGE.length)==SYS_MSG_PSW_CHANGE){
			return SYS_MSG_PSW_CHANGE_MESSAGE;
		}
		
		if (strSysMsgType.substr(0, SYS_MSG_PREFIX.length)==SYS_MSG_PREFIX){
			
			//strMessageTypeID=g_MqRef.MqStr.Mid(strSysMsgType, SYS_MSG_PREFIX.length, 
			//									strSysMsgType.length-SYS_MSG_PREFIX.length);
			//use the message type to get the message
				
			//so far there are none that need it here, just display undefined message if there is something
			return SYS_MSG_UNDEFINED_MESSAGE;
		}
						
	}

	
}





